/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.InPlanRebuildStoreActivity;
import cz.insophy.inplan.store.StoreActivityFactory;
import cz.insophy.inplan.store.StoreActivityOwner;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class RebuildActivity
extends WorkplaceActivity
implements StoreActivityOwner {
    private RebuildType to;
    private List<InPlanRebuildStoreActivity> storeActivities;

    public RebuildActivity(long start, long end, Workplace workplace) {
        this(start, end, workplace, null);
    }

    public RebuildActivity(long start, long end, Workplace workplace, RebuildType to) {
        super(start, end, workplace);
        if (to != null && workplace != null) {
            Preconditions.checkState(workplace.getRebuildTypes().contains(to), "%s is not compatible with %s", (Object)to, (Object)workplace);
        }
        this.to = to;
        this.createStoreActivities();
    }

    public RebuildActivity(RebuildActivity other) {
        this(other.getStart(), other.getEnd(), other.getWorkplace(), other.to);
    }

    public void setTo(RebuildType to) {
        if (to != null && this.getWorkplace() != null) {
            Preconditions.checkState(this.getWorkplace().getRebuildTypes().contains(to), "%s is not compatible with %s", (Object)to, (Object)this.getWorkplace());
        }
        this.to = to;
        this.changeStoreActivities();
    }

    public String getTo() {
        if (this.to == null) {
            return null;
        }
        return this.to.getName();
    }

    @Override
    public Activity duplicate() {
        return new RebuildActivity(this);
    }

    @Nullable
    public RebuildType getToType() {
        return this.to;
    }

    @Override
    public void setStart(long start) {
        super.setStart(start);
        this.changeStoreActivities();
    }

    @Override
    public void setEnd(long end) {
        super.setEnd(end);
        this.changeStoreActivities();
    }

    @Override
    public void setStartEnd(long start, long end) {
        super.setStartEnd(start, end);
        this.changeStoreActivities();
    }

    @Override
    protected void preSetPlan() {
        super.preSetPlan();
        this.removeActivitiesFromPlan();
    }

    @Override
    protected void postSetPlan() {
        super.postSetPlan();
        this.createStoreActivities();
        this.addStoreActivitiesToPlan();
    }

    private void changeStoreActivities() {
        this.removeActivitiesFromPlan();
        this.createStoreActivities();
        this.addStoreActivitiesToPlan();
    }

    private void removeActivitiesFromPlan() {
        Plan plan = this.getPlan();
        if (plan != null) {
            for (InPlanRebuildStoreActivity sa : this.storeActivities) {
                plan.removeActivity(sa);
            }
        }
    }

    private void addStoreActivitiesToPlan() {
        Plan plan = this.getPlan();
        if (plan != null) {
            for (InPlanRebuildStoreActivity sa : this.storeActivities) {
                plan.addActivity(sa);
            }
        }
    }

    private void createStoreActivities() {
        this.storeActivities = this.to != null ? StoreActivityFactory.createStoreActivities(this) : Collections.emptyList();
    }

    public List<InPlanRebuildStoreActivity> getStoreActivities() {
        return this.storeActivities;
    }

    @Override
    void accept(WorkplaceActivityVisitor visitor) {
        visitor.visit(this);
    }
}

